<?php include 'services/session.php'; ?>
<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Tooltips & popovers";
    include 'partials/title-meta.php'; ?>

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "Tooltips & popovers";
    include 'partials/menu.php'; ?>
            
            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="header-title">Popovers</h4>
                                        <p class="sub-header">Add small overlays of content, like those on
                                            the iPad, to any element for housing secondary information.</p>

                                        <div class="button-list" id="popover-container">
                                            
                                            <button type="button" class="btn btn-light" data-bs-container="#popover-container" data-bs-toggle="popover" data-bs-placement="right" data-bs-content="Vivamus sagittis lacus vel augue laoreet rutrum faucibus." data-original-title="">
                                                Popover on right
                                            </button>

                                            <button type="button" class="btn btn-light" data-bs-container="#popover-container" data-bs-toggle="popover" data-bs-placement="top" data-bs-content="Vivamus sagittis lacus vel augue laoreet rutrum faucibus." data-original-title="">
                                                Popover on top
                                            </button>

                                            <button type="button" class="btn btn-light" data-bs-container="#popover-container" data-bs-toggle="popover" data-bs-placement="bottom" data-bs-content="Vivamus sagittis lacus vel augue laoreet rutrum faucibus." data-original-title="">
                                                Popover on bottom
                                            </button>

                                            <button type="button" class="btn btn-light" data-bs-container="#popover-container" data-bs-toggle="popover" data-bs-placement="left" data-bs-content="Vivamus sagittis lacus vel augue laoreet rutrum faucibus." data-original-title="Popover title">
                                                Popover on left
                                            </button>

                                            <button type="button" tabindex="0" class="btn btn-primary" data-bs-container="#popover-container" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-content="And here's some amazing content. It's very engaging. Right?" data-original-title="Dismissible popover">
                                                Dismissible popover
                                            </button>
                                        </div>
                                    </div>
                                </div> <!-- end card -->
                            </div> <!-- end col-->
                        </div>
                        <!-- end row -->

                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="header-title">Tooltips</h4>
                                        <p class="sub-header">Four options are available: top, right, bottom,
                                            and left aligned.</p>

                                        <div class="button-list" id="tooltip-container">
                                            <button type="button" class="btn btn-light" data-bs-container="#tooltip-container" data-bs-toggle="tooltip" data-bs-placement="top" title="Tooltip on top">Tooltip on top</button>

                                            <button type="button" class="btn btn-light" data-bs-container="#tooltip-container" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Tooltip on bottom">Tooltip on bottom</button>

                                            <button type="button" class="btn btn-light" data-bs-container="#tooltip-container" data-bs-toggle="tooltip" data-bs-placement="left" title="Tooltip on left">Tooltip on left</button>

                                            <button type="button" class="btn btn-light" data-bs-container="#tooltip-container" data-bs-toggle="tooltip" data-bs-placement="right" title="Tooltip on right">Tooltip on right</button>
                                        </div>

                                        <h4 class="header-title mt-4">Tippy Tooltips</h4>
                                        <p class="sub-header">A highly customizable vanilla JS tooltip & popover library</p>

                                        <div class="row">
                                            <div class="col-xl-6">
                                                <p class="mb-1 h5">Placement</p>
                                                <p class="text-muted font-13 mb-3">
                                                    The default tippy tooltip looks like this when given no options. It has a nifty backdrop filling animation!
                                                </p>
                                                <div class="button-list" >
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-placement="top">Top</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-placement="bottom">Bottom</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-placement="left">Left</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-placement="right">Right</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-placement="top-start">Top-Start</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-placement="top-end">Top-End</span>
                                                </div>    
                                                
                                                <p class="mb-1 h5 mt-4">Arrows</p>
                                                <p class="text-muted font-13 mb-3">
                                                    Arrows point toward the reference element. 
                                                </p>
                                                <div class="button-list" >
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-arrow="true" data-tippy-animation="fade">Default</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-arrow="true" data-tippy-arrowType="round" data-tippy-animation="fade">Round</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-arrow="true" data-tippy-arrowTransform="scaleX(1.5)" data-tippy-animation="fade">Wide</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-arrow="true" data-tippy-arrowTransform="scaleX(0.75)" data-tippy-animation="fade">Skinny</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-arrow="true" data-tippy-arrowTransform="scale(0.75)" data-tippy-animation="fade">Small</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-arrow="true" data-tippy-arrowTransform="scale(1.35)" data-tippy-animation="fade">Large</span>            
                                                </div>  
                                                
                                                <p class="mb-1 mt-4 h5">Interactivity</p>
                                                <p class="text-muted font-13 mb-3">
                                                    Tooltips can be interactive, meaning they won't hide when you hover over or click on them.
                                                </p>
                                                <div class="button-list" >
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-interactive="true">Interactive (hover)</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-interactive="true" data-tippy-trigger="click">Interactive (click)</span>                       
                                                </div> 

                                                <p class="mb-1 mt-4 h5">Duration</p>
                                                <p class="text-muted font-13 mb-3">
                                                    A tippy can have different transition durations.
                                                </p>
                                                <div class="button-list" >
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-duration="0">0ms</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-duration="200">200ms</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-duration="1000">1000ms</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-duration="[500, 200]">[500ms, 200ms]</span>                                 
                                                </div>  
                                            </div> <!-- end col-->

                                            <div class="col-xl-6 mt-4 mt-xl-0">
                                                <p class="mb-1 h5">Animations</p>
                                                <p class="text-muted font-13 mb-3">
                                                    Tooltips can have different types of animations.
                                                </p>
                                                <div class="button-list" >
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-animation="shift-away" data-tippy-arrow="true">Shift away</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-animation="shift-toward" data-tippy-arrow="true">Shift toward</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-animation="fade" data-tippy-arrow="true">Fade</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-animation="scale" data-tippy-arrow="true">Scale</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-animation="perspective" data-tippy-arrow="true">Perspective</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-animation="shift-away" data-tippy-inertia="true" data-tippy-duration="[600, 300]" data-tippy-arrow="true">Inertia (shift-away)</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-animation="shift-toward" data-tippy-inertia="true" data-tippy-duration="[600, 300]" data-tippy-arrow="true">Inertia (shift-toward)</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-animation="scale" data-tippy-inertia="true" data-tippy-duration="[600, 300]" data-tippy-arrow="true">Inertia (scale)</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-animation="perspective" data-tippy-inertia="true" data-tippy-duration="[600, 300]" data-tippy-arrow="true">Inertia (perspective)</span>                      
                                                </div>    
                                                
                                                <p class="mb-1 h5 mt-4">Themes</p>
                                                <p class="text-muted font-13 mb-3">
                                                    A tippy can have any kind of theme you want! Creating a custom theme is a breeze.
                                                </p>
                                                <div class="button-list" >
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="See-through!" tabindex="0" data-plugin="tippy" data-tippy-theme="translucent">Translucent</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="A light Tooltip !" tabindex="0" data-plugin="tippy" data-tippy-theme="light" data-tippy-arrow="true">Light</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="Awesome Gradient !" tabindex="0" data-plugin="tippy" data-tippy-theme="gradient">Gradient</span>
                                                </div>  
                                                
                                                <p class="mb-1 mt-4 h5">Misc</p>
                                                <p class="text-muted font-13 mb-3">
                                                    Tippy has a ton of features, and it's constantly improving.
                                                </p>
                                                <div class="button-list" >
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="How cool&#39;s this?!" tabindex="0" data-plugin="tippy" data-tippy-followCursor="true" data-tippy-arrow="true" data-tippy-animation="fade">Follow cursor</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="You&#39;ll need a touch device for this one." tabindex="0" data-plugin="tippy" data-tippy-touchHold="true">Touch &amp; Hold</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m hugging the tooltip!" tabindex="0" data-plugin="tippy" data-tippy-distance="0" data-tippy-animation="fade">Distance</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="10px x-axis, 50px y-axis offset" tabindex="0" data-plugin="tippy" data-tippy-offset="10, 50">Offset</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-size="small">Small</span>
                                                    <span class="btn btn-sm btn-primary waves-effect waves-light" title="I&#39;m a Tippy tooltip!" tabindex="0" data-plugin="tippy" data-tippy-size="large">Large</span>                                   
                                                </div> 
    
                                            </div> <!-- end col-->
                                        </div>
                                        <!-- end row-->
                                    </div>
                                </div> <!-- end card -->
                            </div> <!-- end col-->
                        </div>
                        <!-- end row -->
                        
                    </div> <!-- container -->

                </div> <!-- content -->

                <?php include 'partials/footer.php'; ?>

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <?php include 'partials/right-sidebar.php'; ?>

        <?php include 'partials/footer-scripts.php'; ?>

        <!-- Tippy js-->
        <script src="assets/libs/tippy.js/tippy.all.min.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
    </body>
</html>